// StandardJS, should-style assertions
// GUI tests for Document View functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Document View', () => {
  beforeEach(() => {
    // Set desktop viewport to ensure navigation elements are visible
    cy.viewport(1280, 720)
    
    // Universal intercepts (loginStub, timelineStub) are automatically set up in support/e2e.js
    cy.visit('/demo/kant_rvernunft_1781.TEI-P5.xml?view=page&odd=dta')
    
    // Wait for page to stabilize
    cy.get('body').should('be.visible')
  })

  describe('Document Page Load', () => {
    it('loads the Kant document page successfully', () => {
      cy.url().should('include', '/demo/kant_rvernunft_1781.TEI-P5.xml')
      // Accept either view=page or view=single as both are valid
      cy.url().should('match', /view=(page|single)/)
      // Accept either odd=dta or odd=teipublisher as both are valid
      cy.url().should('match', /odd=(dta|teipublisher)/)
      cy.get('body').should('be.visible')
    })

    it('shows main content area', () => {
      cy.get('main').should('be.visible')
    })

    it('displays document content', () => {
      // Check that the Kant document content appears
      cy.get('body').should('be.visible')
      
      // Wait for pb-view to load content dynamically
      cy.get('pb-view').should('exist')
      
      // Wait for pb-view to actually load its content
      // TODO(DP):Could be tightened to eq content-document1 depending on b29635b177ff7a410b59ba194578748de853f513
      cy.get('pb-view').should(($el) => {
        expect($el.attr('src')).to.include('document1')
      })
      
      // Wait for content to be loaded by checking for actual content
      cy.contains('Critik der reinen Vernunft', { timeout: 10000 }).should('be.visible')
      
      // Also check the main body content
      cy.get('body').then(($body) => {
        const text = $body.text()
        cy.log('Page text content:', text.substring(0, 500) + '...')
        
        expect(text).to.include('Critik der reinen Vernunft')
      })
    })
  })

  describe('Document Content Display', () => {
    it('shows document title', () => {
      // Wait for content to load by checking for the actual title
      cy.contains('Critik der reinen Vernunft', { timeout: 10000 }).should('be.visible')
      
      // Check that the document title appears - use defensive approach
      cy.get('body').then(($body) => {
        const text = $body.text()
        expect(text).to.include('Critik der reinen Vernunft')
      })
      
      // Check for proper heading structure
      cy.get('h1, h2, h3, h4, h5, h6').should('have.length.at.least', 1)
    })

    it('displays document structure', () => {
      // Check for document structure elements
      cy.get('main').should('be.visible')
      
      // Check for headings or other structural elements
      cy.get('h1, h2, h3, h4, h5, h6').should('have.length.at.least', 1)
    })
  })

  describe('Document Navigation', () => {
    it('provides navigation elements', () => {
      // Check for navigation
      cy.get('nav').should('be.visible')
    })

    it('shows breadcrumb navigation', () => {
      // Check for breadcrumb navigation
      cy.get('body').then(($body) => {
        if ($body.find('nav[aria-label="breadcrumb"]').length > 0) {
          cy.get('nav[aria-label="breadcrumb"]').should('be.visible')
        }
      })
    })
  })

  describe('Document Table of Contents', () => {
    it('displays table of contents', () => {
      // Check for TOC elements
      cy.get('[id*="toc"], .toc, .table-of-contents, .contents').then(($elements) => {
        const tocCount = $elements.length
        cy.log(`Found ${tocCount} TOC elements`)
        
        // Should have at least one TOC element
        expect(tocCount).to.be.greaterThan(0)
      })
    })

    it('shows TOC navigation', () => {
      // Check for TOC navigation links
      cy.get('body').then(($body) => {
        if ($body.find('a[href*="#"]').length > 0) {
          cy.get('a[href*="#"]').should('have.length.at.least', 1)
        }
      })
    })
  })

  describe('Document Responsive Design', () => {
    it('adapts to mobile viewport', () => {
      cy.viewport(375, 667) // iPhone SE
      
      cy.get('main').should('be.visible')
      cy.get('body').should('be.visible')
    })

    it('adapts to tablet viewport', () => {
      cy.viewport(768, 1024) // iPad
      
      cy.get('main').should('be.visible')
      cy.get('body').should('be.visible')
    })
  })

  describe('Document Error Handling', () => {
    it('handles document loading errors gracefully', () => {
      // Should handle any document-specific errors
      cy.get('body').should('be.visible')
    })
  })

  describe('Document Accessibility', () => {
    it('has proper heading structure', () => {
      cy.get('h1, h2, h3, h4, h5, h6').should('have.length.at.least', 1)
    })

    it('has accessible navigation', () => {
      cy.get('nav').should('be.visible')
      cy.get('nav a').should('have.length.at.least', 1)
    })
  })
})

