// StandardJS, should-style assertions
// API tests for templates functionality
// Generated by jinks - DO NOT EDIT manually

describe('/api/templates [authenticated]', () => {
  beforeEach(() => {
    cy.login()
  })

  it('retrieves a list of templates', () => {
    cy.api('/api/templates')
      .its('status').should('eq', 200)

    cy.api('/api/templates').then(({ body }) => {
      cy.wrap(body).should('be.an', 'array')
      cy.wrap(body.length).should('be.greaterThan', 0)
      // Each template should have properties
      if (body.length > 0) {
        cy.wrap(body[0]).should('have.property', 'name')
      }
    })
  })
})

describe('/api/templates [not authenticated]', () => {
  beforeEach(() => {
    cy.logout()
  })

  it('retrieves a list of templates', () => {
    cy.api('/api/templates')
      .its('status').should('eq', 200)

    cy.api('/api/templates').then(({ body }) => {
      cy.wrap(body).should('be.an', 'array')
      cy.wrap(body.length).should('be.greaterThan', 0)
      // Each template should have properties
      if (body.length > 0) {
        cy.wrap(body[0]).should('have.property', 'name')
      }
    })
  })
})

