// StandardJS, should-style assertions
// API tests for Authentication functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Authentication API', () => {
  // Helper to get origin from Cypress baseUrl
  const getOrigin = () => {
    const baseUrl = Cypress.config('baseUrl')
    if (!baseUrl) {
      throw new Error('baseUrl must be configured in Cypress config')
    }
    return new URL(baseUrl).origin
  }

  beforeEach(() => {
    // Clear any existing authentication state
    cy.clearCookies()
  })

  describe('Login API', () => {
    it('performs successful login with valid credentials', () => {
      cy.login()
      
      // Verify login was successful by checking API response
      cy.request({
        method: 'GET',
        url: '/api/collection',
        headers: { Origin: getOrigin() }
      }).then((response) => {
        expect(response.status).to.eq(200)
      })
    })

    it('handles invalid credentials', () => {
      // Test invalid login attempt
      cy.request({
        method: 'POST',
        url: '/api/login',
        form: true,
        body: { user: 'invalid', password: 'wrong' },
        failOnStatusCode: false
      }).then((response) => {
        expect(response.status).to.eq(401)
      })
    })

    it('handles missing credentials', () => {
      // Test login with missing credentials
      cy.request({
        method: 'POST',
        url: '/api/login',
        form: true,
        body: {},
        failOnStatusCode: false
      }).then((response) => {
        expect(response.status).to.eq(401)
      })
    })
  })

  describe('Logout API', () => {
    it('performs successful logout', () => {
      cy.login()
      
      // Perform logout
      cy.logout()
      
      // Verify logout by checking that cookies are cleared
      cy.getCookies().then((cookies) => {
        const authCookies = cookies.filter(cookie => 
          cookie.name.includes('login') || cookie.name.includes('auth')
        )
        expect(authCookies).to.have.length(0)
      })
    })

    it('handles logout when not logged in', () => {
      // Try to logout when not logged in
      cy.request({
        method: 'POST',
        url: '/api/login',
        qs: { logout: 'true' },
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        failOnStatusCode: false
      }).then((response) => {
        // Should handle gracefully - logout when not logged in should return 200 or 401
        expect(response.status).to.be.oneOf([200, 401])
      })
    })
  })

  describe('Authentication State Persistence', () => {
    it('maintains authentication across API calls', () => {
      cy.login()
      
      // Make multiple API calls to verify persistence
      const apiEndpoints = [
        '/api/collection',
        '/api/info',
        '/api/search/facets'
      ]
      
      apiEndpoints.forEach(endpoint => {
        cy.request({
          method: 'GET',
          url: endpoint,
          headers: { Origin: getOrigin() }
        }).then((response) => {
          expect(response.status).to.eq(200)
        })
      })
    })
  })
})

