// StandardJS, should-style assertions
// API tests for ODD functionality
// Generated by jinks - DO NOT EDIT manually

describe('/api/odd/{odd} [authenticated]', () => {
  beforeEach(() => {
    cy.login()
  })

  it('creates new odd', () => {
    cy.getCookies().then(cookies => {
      const cookieHeader = cookies.map(c => `${c.name}=${c.value}`).join('; ')
      cy.api({
        method: 'POST',
        url: '/api/odd/testme',
        qs: { title: 'My test' },
        headers: { Cookie: cookieHeader }
      })
        .its('status').should('eq', 201)

      cy.api({
        method: 'POST',
        url: '/api/odd/testme',
        qs: { title: 'My test' },
        headers: { Cookie: cookieHeader }
      })
        .its('body.path').should('include', 'testme.odd')
    })
  })

  it('retrieves odd as xml', () => {
    cy.request({
      method: 'GET',
      url: '/api/odd/testme.odd',
      headers: { Accept: 'application/xml' }
    })
      .its('status').should('eq', 200)

    cy.request({
      method: 'GET',
      url: '/api/odd/testme.odd',
      headers: { Accept: 'application/xml' }
    })
      .its('body').should('match', /schemaSpec/)
  })

  it('loads odd as json', () => {
    cy.request({
      method: 'GET',
      url: '/api/odd/testme.odd',
      headers: { Accept: 'application/json' }
    })
      .its('status').should('eq', 200)

    cy.request({
      method: 'GET',
      url: '/api/odd/testme.odd',
      headers: { Accept: 'application/json' }
    })
      .its('headers["content-type"]').should('include', 'application/json')

    cy.request({
      method: 'GET',
      url: '/api/odd/testme.odd',
      headers: { Accept: 'application/json' }
    })
      .its('body.title').should('include', 'My test')
  })

  it('deletes odd', () => {
    cy.getCookies().then(cookies => {
      const cookieHeader = cookies.map(c => `${c.name}=${c.value}`).join('; ')
      cy.api({
        method: 'DELETE',
        url: '/api/odd/testme.odd',
        headers: { Cookie: cookieHeader },
        failOnStatusCode: false
      })
        .its('status').should('eq', 410)
    })
  })

  after(() => {
    cy.logout()
  })
})

describe('/api/odd/{odd} [not authenticated]', () => {
  before(() => {
    cy.logout()
  })

  it('tries to delete odd', () => {
    cy.request({
      method: 'DELETE',
      url: '/api/odd/teipublisher.odd',
      failOnStatusCode: false
    })
      .its('status').should('eq', 401)
  })

  it('tries to create new odd', () => {
    cy.request({
      method: 'POST',
      url: '/api/odd/testme',
      qs: { title: 'My test' },
      failOnStatusCode: false
    })
      .its('status').should('eq', 401)
  })
})

describe('/api/odd [authenticated]', () => {
  beforeEach(() => {
    cy.login()
  })

  it('retrieves a list of odds', () => {
    cy.request('/api/odd')
      .its('status').should('eq', 200)

    cy.request('/api/odd')
      .its('body').should('be.an', 'array')

    cy.request('/api/odd')
      .its('body').then(body => {
        // Should have at least one ODD
        cy.wrap(body.length).should('be.greaterThan', 0)
        // Each ODD should have required properties
        if (body.length > 0) {
          cy.wrap(body[0]).should('have.property', 'name')
          cy.wrap(body[0]).should('have.property', 'path')
        }
      })
  })

  after(() => {
    cy.logout()
  })
})

describe('/api/odd [not authenticated]', () => {
  it('tries to regenerate odd without authorization', () => {
    cy.request({
      method: 'POST',
      url: '/api/odd',
      qs: { odd: 'dta.odd', check: true },
      failOnStatusCode: false
    })
      .its('status').should('eq', 401)
  })
})

