// StandardJS, should-style assertions
// GUI tests for Timeline functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Timeline', () => {
  beforeEach(() => {
    // Setup timeline fixture for test data
    cy.setupTimelineFixture()
    // Setup search intercepts for pagination updates
    cy.setupSearchIntercepts()
    
    cy.visit('/browse.html', {
      qs: {
        collection: Cypress.env('TIMELINE_TEST_COLLECTION') || 'demo'
      }
    })
    
    // Wait for page to stabilize
    cy.get('body').should('be.visible')
  })

  describe('Timeline Component', () => {
    it('displays timeline component on browse page', () => {
      // Timeline appears on browse pages when enabled
      cy.get('pb-timeline', { timeout: 10000 })
        .should('exist')
        .should('be.visible')
    })

    it('loads timeline data from API', () => {
      // Wait for timeline API call
      cy.wait('@timelineApi', { timeout: 10000 })
      
      // Verify timeline component is present
      cy.get('pb-timeline')
        .should('be.visible')
    })

    it('displays timeline bins/containers', () => {
      cy.wait('@timelineApi', { timeout: 10000 })
      
      // Check for timeline bins (date containers)
      cy.get('pb-timeline')
        .find('div.bin-container, [class*="bin"], [data-tooltip]')
        .should('have.length.at.least', 0) // May have bins or may be empty depending on data
    })
  })

  describe('Timeline Interaction', () => {
    it('responds to timeline bin interactions', () => {
      cy.wait('@timelineApi', { timeout: 10000 })
      
      cy.get('pb-timeline')
        .find('div.bin-container, [class*="bin"]')
        .then(($bins) => {
          if ($bins.length > 0) {
            // Click first bin if available
            cy.wrap($bins.first())
              .click({ force: true })
            
            // Timeline may trigger search API or filter client-side
            // Give time for interaction to complete
            cy.wait(1000)
            
            // Verify pagination exists (may or may not update depending on implementation)
            cy.get('pb-paginate', { timeout: 10000 })
              .should('exist')
          } else {
            cy.log('No timeline bins available in demo data')
          }
        })
    })

    it('shows tooltip on hover when available', () => {
      cy.wait('@timelineApi', { timeout: 10000 })
      
      cy.get('pb-timeline')
        .find('div.bin-container, [class*="bin"]')
        .then(($bins) => {
          if ($bins.length > 0) {
            // Hover over first bin
            cy.wrap($bins.first())
              .trigger('mousemove', 'center')
            
            // Check for tooltip (if implemented)
            cy.get('body').then(($body) => {
              const hasTooltip = $body.find('div#tooltip-text, [class*="tooltip"]').length > 0
              // Tooltip is optional, so we just verify interaction works
              expect($bins.length).to.be.greaterThan(0)
            })
          } else {
            cy.log('No timeline bins available to test tooltip')
          }
        })
    })
  })

  describe('Timeline-Pagination Integration', () => {
    it('updates pagination when timeline filter is applied', () => {
      cy.wait('@timelineApi', { timeout: 10000 })
      
      // Get initial pagination total
      cy.get('pb-paginate')
        .invoke('attr', 'total')
        .as('initialTotal')
      
      cy.get('pb-timeline')
        .find('div.bin-container, [class*="bin"]')
        .then(($bins) => {
          if ($bins.length > 0) {
            // Click a timeline bin
            cy.wrap($bins.first())
              .click({ force: true })
            
            // Timeline may trigger search API or filter client-side
            // Give time for interaction to complete
            cy.wait(1000)
            
            // Verify pagination exists and has total attribute
            cy.get('pb-paginate', { timeout: 10000 })
              .should('exist')
              .should('have.attr', 'total')
            
            // Get the total value separately
            cy.get('pb-paginate')
              .invoke('attr', 'total')
              .should('exist')
              .should('not.be.empty')
          } else {
            cy.log('No timeline bins available for integration test')
          }
        })
    })
  })

  describe('Timeline Configuration', () => {
    it('displays timeline label', () => {
      cy.get('pb-timeline')
        .find('span[slot="label"]')
        .should('exist')
    })

    it('has configured scopes', () => {
      // Timeline should have scopes attribute configured
      cy.get('pb-timeline')
        .should('have.attr', 'scopes')
    })
  })
})

