This profile contains the default theme for TEI Publisher 10.

# Configuration properties

The following table shows the current list of settings which can be changed via an app's JSON configuration:

<!-- START: Generated documentation. Keep this line -->

| Property | Description | Default |
|----------|-------------|-------
| `body.background-color` | Background color for the body element | `"var(--jinks-colors-100)"` |
| `breadcrumbs.max` | max length of the breadcrumbs in the toolbar. Longer breadcrumbs will be truncated with an ellipsis. | `"40ch"` |
| `colors.palette` | Predefined color palette to use for the application | `"neutral"` |
| `colors.palettes.beige` | *No description available* | `"palette-beige.css"` |
| `colors.palettes.blue` | *No description available* | `"palette-blue.css"` |
| `colors.palettes.green` | *No description available* | `"palette-green.css"` |
| `colors.palettes.neutral` | *No description available* | `"palette-neutral.css"` |
| `colors.palettes.teal` | *No description available* | `"palette-teal.css"` |
| `content.max-width` | Maximum width of the content area for better readability | `"70ch"` |
| `fonts.base.family` | Font family for the base font | `"'Inter', 'Noto', sans-serif"` |
| `fonts.base.line-height` | Line height for the base font. | `"1.4"` |
| `fonts.base.size` | Font size for the base font. Use `rem` for relative size. | `"16px"` |
| `fonts.base.weight` | Font weight for the base font. Use `normal` for regular weight, `bold` for bold weight, etc. | `"400"` |
| `fonts.breadcrumbs.size` | Font size for breadcrumbs. Use `rem` for relative size. | `"0.9rem"` |
| `fonts.content.family` | Font family for the content area | `"JunicodeVF, Georgia, 'Times New Roman', serif"` |
| `fonts.content.line-height` | *No description available* | `"150%"` |
| `fonts.content.size` | Font size for the content area. Use `rem` for relative size. | `"1.25rem"` |
| `fonts.content.weight` | Font weight for the content area. Use `normal` for regular weight, `bold` for bold weight, etc. | `"400"` |
| `fonts.footnote.size` | Font size for footnotes. Use `rem` for relative size. | `"0.9em"` |
| `fonts.heading.family` | Font family for headings | `"'Inter', 'Noto', sans-serif"` |
| `fonts.heading.size` | Font size for headings. Use `rem` for relative size. | `"1.2rem"` |
| `fonts.heading.weight` | Font weight for headings. Use `normal` for regular weight, `bold` for bold weight, etc. | `"400"` |
| `fonts.menubar.size` | Font size for the menubar. Use `rem` for relative size. | `"14px"` |
| `fonts.toc.size` | Font size for table of contents. Use `rem` for relative size. | `"1.125rem"` |
| `layout.after.hidden` | If true, the after sidebar will be initially hidden | `false` |
| `layout.after.toggle` | If true, add a toggle button to the after sidebar to collapse and expand | `true` |
| `layout.after.width` | Width of the after sidebar | `"min(30vw, 356px)"` |
| `layout.before.hidden` | If true, the before sidebar will be initially hidden | `false` |
| `layout.before.toggle` | If true, add a toggle button to the before sidebar to collapse and expand | `true` |
| `layout.before.width` | Width of the before sidebar | `"min(30vw, 356px)"` |
| `layout.class` | Class to add to the main container element of the page | `"fixed-layout"` |
| `layout.footer.mobile.enabled` | *No description available* | `true` |
| `layout.max-width` | Width of the landing page content column | `"84rem"` |
| `layout.search` | Position of the search input on the browse page | `"before-top"` |
| `logo.height` | Height of the logo | `"48px"` |
| `logo.image` | Image to use for the logo. Path should be relative to `resources/css`. | `"../images/tei-publisher-logo-contrast-color.svg"` |
| `logo.width` | Width of the logo | `"140px"` |
| `menubar.background-color` | Background color for the menubar | `"var(--jinks-colors-500)"` |
| `menubar.background-image` | Background image for the menubar | `"none"` |
| `menubar.color` | Color for the menubar text | `"#ffffff"` |
| `splash.height` | Height of the splash image | `"auto"` |
| `splash.image` | Image to use for the splash screen. Path should be relative to `resources/css`. | `"../images/tei-publisher-logo-color.svg"` |
| `splash.width` | Width of the splash image | `"320px"` |
| `texture.background-image` | *No description available* | `null` |
| `toolbar.background-color` | Background color for the toolbar | `"var(--jinks-colors-200)"` |
| `toolbar.color` | Color for the toolbar text | `"var(--jinks-color-primary)"` |

> **Note:** Values shown are from `profiles/theme-base10/config.json`. Descriptions are from `schema/jinks.json`. This section is auto-generated by `generate-theme-docs.js`.


<!-- END: Keep this line -->

## Credits

This feature has been primarily funded via [Jagiellonian Digital Platform](https://labedyt.dhlab.uj.edu.pl/)

![dhlab](../../../resources/images/dhlab.svg)