// StandardJS, should-style assertions
// GUI tests for Places Register functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Places Register', () => {
  beforeEach(() => {
    // Universal intercepts (loginStub, timelineStub) are automatically set up in support/e2e.js
    // Setup register-specific intercepts
    cy.setupRegisterIntercepts(['places'])
    
    cy.visit('/places')
    
    // Wait for page to stabilize
    cy.get('body').should('be.visible')
  })

  describe('Places Register Page', () => {
    it('loads the places register page successfully', () => {
      cy.url().should('include', '/places')
      cy.get('body').should('be.visible')
    })

    it('displays page title', () => {
      cy.title().should('not.be.empty')
    })

    it('shows main content area', () => {
      cy.get('main, .places, [class*="list"]').should('exist')
    })

    it('displays map component', () => {
      // Places page includes a leaflet map
      cy.get('pb-leaflet-map, #map, [class*="map"]')
        .should('exist')
        .should('be.visible')
    })
  })

  describe('Places Register List', () => {
    it('displays register list component', () => {
      cy.get('pb-split-list, .register-list, [class*="register"]')
        .should('exist')
        .should('be.visible')
    })

    it('shows register items when available', () => {
      // Wait for API call to complete
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Check for register items
      cy.get('body').then(($body) => {
        const hasItems = $body.find('span.place, .place, pb-split-list li, [class*="place"], [class*="register-item"]').length > 0 ||
                         $body.find('pb-split-list').length > 0
        
        // Items may exist, but we verify the component is present
        expect(hasItems || $body.find('pb-split-list').length > 0).to.be.true
      })
    })

    it('displays place names from demo data', () => {
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Wait for register content to load
      cy.get('pb-split-list, .places', { timeout: 10000 })
        .should('exist')
      
      // Check if place names are visible (from demo data: Madrid, Mexico City, etc.)
      cy.get('body').then(($body) => {
        const text = $body.text().toLowerCase()
        // Demo data contains these place names
        const hasPlaceContent = text.includes('madrid') || 
                               text.includes('mexico') ||
                               $body.find('pb-split-list').length > 0
        
        expect(hasPlaceContent).to.be.true
      })
    })
  })

  describe('Places Register Search', () => {
    it('displays search input field', () => {
      cy.get('#places-query, input[name="search"], input[type="search"]')
        .should('exist')
        .should('be.visible')
    })

    it('accepts search input', () => {
      cy.get('#places-query, input[name="search"], input[type="search"]')
        .first()
        .type('test')
        .should('have.value', 'test')
    })

    it('filters results on search', () => {
      // Wait for initial load
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Perform search (using name from demo data)
      cy.get('#places-query, input[name="search"], input[type="search"]')
        .first()
        .clear()
        .type('Madrid{enter}')
      
      // Search navigates to search.html page with query parameter
      cy.url({ timeout: 10000 }).should('include', '/search.html')
      cy.url().should('include', 'query=Madrid')
      
      // Verify search results page loaded
      cy.get('body', { timeout: 10000 })
        .should('be.visible')
    })

    it('handles empty search results', () => {
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Search for something unlikely to exist
      cy.get('#places-query, input[name="search"], input[type="search"]')
        .first()
        .clear()
        .type('nonexistentplacexyz123{enter}')
      
      // Search navigates to search.html page
      cy.url({ timeout: 10000 }).should('include', '/search.html')
      cy.url().should('include', 'query=')
      
      // Page should still be visible even with no results
      cy.get('body').should('be.visible')
    })
  })

  describe('Places Register Navigation', () => {
    it('navigates to place detail page on click', () => {
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Find a place link (from demo data)
      cy.get('body').then(($body) => {
        const placeLinks = $body.find('a[href*="/places/"], a[href*="places?ref="], span.place a, [class*="place"] a')
        
        if (placeLinks.length > 0) {
          // Click first place link
          cy.wrap(placeLinks.first())
            .click({ force: true })
          
          // Verify URL changed to place detail
          cy.url({ timeout: 10000 })
            .should('match', /\/places\/.+/)
          
          // Verify detail page loaded
          cy.get('body').should('be.visible')
        } else {
          cy.log('No place links available in demo data')
        }
      })
    })
  })

  describe('Places Register Map Integration', () => {
    it('displays map on places list page', () => {
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Map should exist - may take time to render
      cy.get('pb-leaflet-map, #map', { timeout: 10000 })
        .should('exist')
      
      // Map component exists - visibility check may fail if map is still loading
      // or if it's in a collapsed/hidden state, so we just verify it exists
      cy.log('Map component found on places list page')
    })

    it('shows geolocation on place detail page', () => {
      cy.wait('@placesApi', { timeout: 10000 })
      
      // Navigate to a place detail if links exist
      cy.get('body').then(($body) => {
        const placeLinks = $body.find('a[href*="/places/"], a[href*="places?ref="]')
        
        if (placeLinks.length > 0) {
          cy.wrap(placeLinks.first())
            .click({ force: true })
          
          // Wait for navigation to complete
          cy.url({ timeout: 10000 }).should('match', /\/places\/.+/)
          
          // Give time for page to load (detail page may not trigger new API call)
          cy.wait(1000)
          
          // Check for geolocation component on detail page
          cy.get('pb-geolocation, #locations, [class*="location"]', { timeout: 10000 })
            .should('exist')
        } else {
          cy.log('No place links available to test detail page')
        }
      })
    })
  })
})

