// StandardJS, should-style assertions
// GUI tests for People Register functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher People Register', () => {
  beforeEach(() => {
    // Universal intercepts (loginStub, timelineStub) are automatically set up in support/e2e.js
    // Setup register-specific intercepts
    cy.setupRegisterIntercepts(['people'])
    
    cy.visit('/people')
    
    // Wait for page to stabilize
    cy.get('body').should('be.visible')
  })

  describe('People Register Page', () => {
    it('loads the people register page successfully', () => {
      cy.url().should('include', '/people')
      cy.get('body').should('be.visible')
    })

    it('displays page title', () => {
      cy.title().should('not.be.empty')
    })

    it('shows main content area', () => {
      cy.get('main, .people, [class*="list"]').should('exist')
    })
  })

  describe('People Register List', () => {
    it('displays register list component', () => {
      cy.get('pb-split-list, .register-list, [class*="register"]')
        .should('exist')
        .should('be.visible')
    })

    it('shows register items when available', () => {
      // Wait for API call to complete
      cy.wait('@peopleApi', { timeout: 10000 })
      
      // Check for register items
      cy.get('body').then(($body) => {
        const hasItems = $body.find('span.register-item, .register-item, pb-split-list li, [class*="register-item"]').length > 0 ||
                         $body.find('pb-split-list').length > 0
        
        // Items may exist, but we verify the component is present
        expect(hasItems || $body.find('pb-split-list').length > 0).to.be.true
      })
    })

    it('displays register items with names', () => {
      cy.wait('@peopleApi', { timeout: 10000 })
      
      // Wait for register content to load
      cy.get('pb-split-list, .people', { timeout: 10000 })
        .should('exist')
      
      // Check if person names are visible (from demo data: Dantiscus, Sigismund, etc.)
      cy.get('body').then(($body) => {
        const text = $body.text().toLowerCase()
        // Demo data contains these names
        const hasPersonContent = text.includes('dantiscus') || 
                                 text.includes('sigismund') ||
                                 $body.find('pb-split-list').length > 0
        
        expect(hasPersonContent).to.be.true
      })
    })
  })

  describe('People Register Search', () => {
    it('displays search input field', () => {
      cy.get('#people-query, input[name="search"], input[type="search"]')
        .should('exist')
        .should('be.visible')
    })

    it('accepts search input', () => {
      cy.get('#people-query, input[name="search"], input[type="search"]')
        .first()
        .type('test')
        .should('have.value', 'test')
    })

    it('filters results on search', () => {
      // Wait for initial load
      cy.wait('@peopleApi', { timeout: 10000 })
      
      // Perform search (using name from demo data)
      cy.get('#people-query, input[name="search"], input[type="search"]')
        .first()
        .clear()
        .type('Dantiscus{enter}')
      
      // Search navigates to search.html page with query parameter
      cy.url({ timeout: 10000 }).should('include', '/search.html')
      cy.url().should('include', 'query=Dantiscus')
      
      // Verify search results page loaded
      cy.get('body', { timeout: 10000 })
        .should('be.visible')
    })

    it('handles empty search results', () => {
      cy.wait('@peopleApi', { timeout: 10000 })
      
      // Search for something unlikely to exist
      cy.get('#people-query, input[name="search"], input[type="search"]')
        .first()
        .clear()
        .type('nonexistentxyz123{enter}')
      
      // Search navigates to search.html page
      cy.url({ timeout: 10000 }).should('include', '/search.html')
      cy.url().should('include', 'query=')
      
      // Page should still be visible even with no results
      cy.get('body').should('be.visible')
    })
  })

  describe('People Register Navigation', () => {
    it('navigates to person detail page on click', () => {
      cy.wait('@peopleApi', { timeout: 10000 })
      
      // Find a person link (from demo data)
      cy.get('body').then(($body) => {
        const personLinks = $body.find('a[href*="/people/"], a[href*="people?ref="], span.register-item a')
        
        if (personLinks.length > 0) {
          // Click first person link
          cy.wrap(personLinks.first())
            .click({ force: true })
          
          // Verify URL changed to person detail
          cy.url({ timeout: 10000 })
            .should('match', /\/people\/.+/)
          
          // Verify detail page loaded
          cy.get('body').should('be.visible')
        } else {
          cy.log('No person links available in demo data')
        }
      })
    })
  })
})

