// StandardJS, should-style assertions
// GUI tests for Bibliography Register functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Bibliography Register', () => {
  beforeEach(() => {
    // Universal intercepts (loginStub, timelineStub) are automatically set up in support/e2e.js
    // Setup register-specific intercepts
    cy.setupRegisterIntercepts(['bibliography'])
    
    cy.visit('/bibliography')
    
    // Wait for page to stabilize
    cy.get('body').should('be.visible')
  })

  describe('Bibliography Register Page', () => {
    it('loads the bibliography register page successfully', () => {
      cy.url().should('include', '/bibliography')
      cy.get('body').should('be.visible')
    })

    it('displays page title', () => {
      cy.title().should('not.be.empty')
    })

    it('shows main content area', () => {
      cy.get('main, .people, [class*="list"]').should('exist')
    })
  })

  describe('Bibliography Register List', () => {
    it('displays register list component', () => {
      // Wait for API call to complete first
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Component may exist but not be visible if empty or still loading
      cy.get('pb-split-list, .register-list, [class*="register"], table', { timeout: 10000 })
        .should('exist')
      // Check if it's visible, but don't fail if it has 0 height (may be empty or loading)
      cy.get('body').then(($body) => {
        const component = $body.find('pb-split-list, table').first()
        if (component.length > 0) {
          // Component exists, check if it has content
          const hasContent = component.find('li, tr, .split-list-item').length > 0
          if (hasContent) {
            cy.wrap(component).should('be.visible')
          } else {
            cy.log('Component exists but may be empty or still loading')
          }
        }
      })
    })

    it('shows bibliography entries when available', () => {
      // Wait for API call to complete
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Check for bibliography entries (may be in table or list format)
      cy.get('body').then(($body) => {
        const hasEntries = $body.find('table tr, tbody tr, .split-list-item, pb-split-list li, [class*="bibliography"]').length > 0 ||
                           $body.find('pb-split-list, table').length > 0
        
        // Items may exist, but we verify the component/structure is present
        expect(hasEntries || $body.find('pb-split-list, table').length > 0).to.be.true
      })
    })

    it('displays bibliography entries with content', () => {
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Wait for register content to load
      cy.get('pb-split-list, table, .bibliography', { timeout: 10000 })
        .should('exist')
      
      // Check if bibliography content is visible (from demo data)
      cy.get('body').then(($body) => {
        const text = $body.text().toLowerCase()
        // Demo data contains entries with author "Laks Sz."
        const hasBibliographyContent = text.includes('laks') || 
                                     text.includes('bibl') ||
                                     $body.find('pb-split-list, table').length > 0
        
        expect(hasBibliographyContent).to.be.true
      })
    })

    it('displays table structure when using table format', () => {
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Bibliography may be displayed as a table
      cy.get('body').then(($body) => {
        const hasTable = $body.find('table, caption, thead, tbody').length > 0
        
        if (hasTable) {
          // If table format, verify structure
          cy.get('table').should('exist')
          cy.get('caption, thead, tbody').should('exist')
        } else {
          // Or may be list format
          cy.get('pb-split-list, .list').should('exist')
        }
      })
    })
  })

  describe('Bibliography Register Search', () => {
    it('displays search input field', () => {
      cy.get('#bibliography-query, input[name="search"], input[type="search"]')
        .should('exist')
        .should('be.visible')
    })

    it('accepts search input', () => {
      cy.get('#bibliography-query, input[name="search"], input[type="search"]')
        .first()
        .type('test')
        .should('have.value', 'test')
    })

    it('filters results on search', () => {
      // Wait for initial load
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Perform search (using content from demo data)
      cy.get('#bibliography-query, input[name="search"], input[type="search"]')
        .first()
        .clear()
        .type('Laks{enter}')
      
      // Search navigates to search.html page with query parameter
      cy.url({ timeout: 10000 }).should('include', '/search.html')
      cy.url().should('include', 'query=Laks')
      
      // Verify search results page loaded
      cy.get('body', { timeout: 10000 })
        .should('be.visible')
    })

    it('handles empty search results', () => {
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Search for something unlikely to exist
      cy.get('#bibliography-query, input[name="search"], input[type="search"]')
        .first()
        .clear()
        .type('nonexistentbibxyz123{enter}')
      
      // Search navigates to search.html page
      cy.url({ timeout: 10000 }).should('include', '/search.html')
      cy.url().should('include', 'query=')
      
      // Page should still be visible even with no results
      cy.get('body').should('be.visible')
    })
  })

  describe('Bibliography Register Navigation', () => {
    it('navigates to bibliography entry detail page on click', () => {
      cy.wait('@bibliographyApi', { timeout: 10000 })
      
      // Find a bibliography entry link (from demo data)
      cy.get('body').then(($body) => {
        const entryLinks = $body.find('a[href*="/bibliography/"], a[href*="bibliography?ref="], table tr a, .split-list-item a, [class*="bibliography"] a')
        
        if (entryLinks.length > 0) {
          // Click first entry link
          cy.wrap(entryLinks.first())
            .click({ force: true })
          
          // Verify URL changed to entry detail
          cy.url({ timeout: 10000 })
            .should('match', /\/bibliography\/.+/)
          
          // Verify detail page loaded
          cy.get('body').should('be.visible')
        } else {
          cy.log('No bibliography entry links available in demo data')
        }
      })
    })
  })
})

