# Landing Page Configuration Options

This profiles adds a landing page to an application, featuring various sections which are commonly used. The content of the sections is provided by a TEI document, which will be rendered via `landing-page.odd`. The default content is taken from `data/landing/landing.xml`. You can change the TEI file to be used in the configuration by setting the `data.landing` parameter. For example, the Documentation and Demo blueprint sets this to:

```json
"data": {
    "landing": "landing/home.xml"
}
```

**Note:** If you add a landing page to an existing application, you have to run the _Fix ODDs_ action!!!

<!-- START: Generated documentation. Keep this line -->

| Property | Description | Default |
|----------|-------------|-------
| `landing.bottom.background-color` | Background color for the bottom section | `"rgba(0, 0, 0, 0.4)"` |
| `landing.bottom.background-image` | Background image for the bottom section. Path should be relative to `resources/css`. | `"../images/typewriter3.jpg"` |
| `landing.bottom.background-repeat` | Background repeat for the bottom section | `"no-repeat"` |
| `landing.bottom.background-size` | Background size for the bottom section | `"cover"` |
| `landing.hero.background-color` | Background color for the hero section | `"rgba(0, 0, 0, 0.6)"` |
| `landing.hero.background-image` | Background image for the hero section. Path should be relative to `resources/css`. | `"../images/typewriter1.jpg"` |
| `landing.hero.background-position` | Background position for the hero section | `"center"` |
| `landing.hero.background-repeat` | Background repeat for the hero section | `"no-repeat"` |
| `landing.hero.background-size` | Background size for the hero section | `"cover"` |
| `landing.hero.class` | *No description available* | `"two-column"` |

> **Note:** Values shown are from `profiles/landing-page/config.json`. Descriptions are from `schema/jinks.json`. This section is auto-generated by `generate-theme-docs.js`.


<!-- END: Keep this line -->