// StandardJS, should-style assertions
// GUI tests for Edition Navigation functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Edition Navigation', () => {
  beforeEach(() => {
    // Universal intercepts (loginStub, timelineStub) are automatically set up in support/e2e.js
    // Setup navigation-specific intercepts
    cy.setupNavigationIntercepts()
    
    // Navigate to a document that supports navigation
    cy.visit('/demo/kant_rvernunft_1781.TEI-P5.xml?view=page&odd=dta')
    
    // Wait for page to stabilize
    cy.get('body').should('be.visible')
    cy.get('pb-view, pb-document', { timeout: 10000 }).should('exist')
  })

  describe('Navigation Component', () => {
    it('displays navigation components when available', () => {
      // Navigation may be provided by pb-navigation or pb-view internal navigation
      cy.get('body').then(($body) => {
        const hasNavigation = $body.find('pb-navigation, [class*="navigation"], button[aria-label*="previous"], button[aria-label*="next"]').length > 0 ||
                             $body.find('pb-view').length > 0
        
        // pb-view supports navigation even without explicit pb-navigation component
        expect(hasNavigation || $body.find('pb-view').length > 0).to.be.true
      })
    })

    it('supports keyboard navigation', () => {
      // Focus body to enable keyboard shortcuts
      cy.get('body')
        .click()
        .wait(500)
      
      // Press right arrow for next
      cy.get('body')
        .type('{rightArrow}', { force: true })
      
      // Wait for navigation to trigger API call
      cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
      
      // Verify page content updated (URL or content changed)
      cy.get('body')
        .should('be.visible')
      
      // Press left arrow for previous
      cy.get('body')
        .type('{leftArrow}', { force: true })
      
      // Wait for navigation back
      cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
      
      // Verify navigation worked
      cy.get('body')
        .should('be.visible')
    })
  })

  describe('Navigation via Component', () => {
    it('navigates forward when next button is clicked', () => {
      // Check if explicit navigation buttons exist
      cy.get('body').then(($body) => {
        const nextButtons = $body.find('pb-navigation[keyboard=right], button[aria-label*="next"], a[title*="next"], iron-icon[icon="chevron-right"]')
        
        if (nextButtons.length > 0) {
          // Get current URL or content marker
          cy.url()
            .as('initialUrl')
          
          // Click next
          cy.wrap(nextButtons.first())
            .click({ force: true })
          
          // Wait for navigation API
          cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
          
          // Verify navigation occurred (URL or content changed)
          cy.url()
            .then((newUrl) => {
              cy.get('@initialUrl').then((initialUrl) => {
                // URL may change or content may update without URL change
                expect(newUrl).to.be.a('string')
              })
            })
        } else {
          cy.log('No explicit navigation buttons found, using keyboard navigation instead')
        }
      })
    })

    it('navigates backward when previous button is clicked', () => {
      // First navigate forward if possible
      cy.get('body')
        .type('{rightArrow}', { force: true })
      
      cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
      
      // Get current state
      cy.url()
        .as('forwardUrl')
      
      // Check if previous buttons exist
      cy.get('body').then(($body) => {
        const prevButtons = $body.find('pb-navigation[keyboard=left], button[aria-label*="previous"], a[title*="previous"], iron-icon[icon="chevron-left"]')
        
        if (prevButtons.length > 0) {
          // Click previous
          cy.wrap(prevButtons.first())
            .click({ force: true })
          
          // Wait for navigation API
          cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
          
          // Verify navigation back occurred
          cy.url()
            .then((backUrl) => {
              cy.get('@forwardUrl').then((forwardUrl) => {
                // Should have navigated back
                expect(backUrl).to.be.a('string')
              })
            })
        } else {
          // Use keyboard for previous
          cy.get('body')
            .type('{leftArrow}', { force: true })
          
          cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
        }
      })
    })
  })

  describe('Navigation State', () => {
    it('handles navigation at document boundaries', () => {
      // Try to navigate beyond boundaries
      // This should gracefully handle end of document
      cy.get('body')
        .type('{rightArrow}', { force: true })
        .wait(500)
        .type('{rightArrow}', { force: true })
        .wait(500)
        .type('{rightArrow}', { force: true })
      
      // Should still be on a valid page
      cy.get('body')
        .should('be.visible')
      
      // Navigate back
      cy.get('body')
        .type('{leftArrow}', { force: true })
        .wait(500)
        .type('{leftArrow}', { force: true })
      
      cy.get('body')
        .should('be.visible')
    })

    it('updates document content on navigation', () => {
      // Get initial content marker
      cy.get('body')
        .then(($body) => {
          const initialText = $body.text().substring(0, 100)
          cy.wrap(initialText).as('initialContent')
        })
      
      // Navigate
      cy.get('body')
        .type('{rightArrow}', { force: true })
      
      cy.wait(['@partsApi', '@viewApi'], { timeout: 10000 })
      
      // Content should have updated (may be same if at boundary)
      cy.get('body', { timeout: 10000 })
        .should('be.visible')
    })
  })
})

