// StandardJS, should-style assertions
// API tests for document view functionality
// Generated by jinks - DO NOT EDIT manually

describe('/{doc}', () => {
  it('Should retrieve matching view template', () => {
    cy.request('/demo%2Flet695.xml')
      .its('status').should('eq', 200)

    cy.request('/demo%2Flet695.xml').then(({ body }) => {
      const doc = new DOMParser().parseFromString(body, 'text/html')
      // Check for basic HTML structure instead of specific meta tags
      expect(doc.querySelector('html')).to.not.be.null
      expect(doc.querySelector('body')).to.not.be.null
      // Check for pb-page element which should be present
      const pbPage = doc.querySelector('pb-page')
      expect(pbPage).to.not.be.null
    })
  })

  it('fails to load template for non-existing document', () => {
    cy.request({ url: '/foo.xml', failOnStatusCode: false })
      .its('status').should('eq', 200)

    cy.request({ url: '/foo.xml', failOnStatusCode: false }).then(({ body }) => {
      const doc = new DOMParser().parseFromString(body, 'text/html')
      // Check for error page content instead of specific error message
      expect(doc.querySelector('html')).to.not.be.null
      expect(body).to.include('Ooops')
    })
  })
})

describe('/{file}.html', () => {
  it('Should retrieve HTML file', () => {
    cy.request('/collection.html')
      .its('status').should('eq', 200)

    cy.request('/collection.html').then(({ body }) => {
      const doc = new DOMParser().parseFromString(body, 'text/html')
      // Check for basic HTML structure
      expect(doc.querySelector('html')).to.not.be.null
      expect(doc.querySelector('body')).to.not.be.null
    })
  })

  it('fails to load HTML file', () => {
    cy.request({ url: '/foo.html', failOnStatusCode: false })
      .its('status').should('eq', 200)

    cy.request({ url: '/foo.html', failOnStatusCode: false }).then(({ body }) => {
      const doc = new DOMParser().parseFromString(body, 'text/html')
      // Check for error page content instead of specific error message
      expect(doc.querySelector('html')).to.not.be.null
      expect(body).to.include('Ooops')
    })
  })
})

