// StandardJS, should-style assertions
// API tests for document retrieval functionality
// Generated by jinks - DO NOT EDIT manually

describe('/api/document/{id}', () => {
  it('retrieves as xml', () => {
    cy.request('/api/document/demo%2Flet695.xml').then(({ status, headers, body }) => {
      expect(status).to.eq(200)
      expect(headers['content-type']).to.eq('application/xml')
      expect(body).to.include('<TEI')
    })
  })

  it('retrieves as markdown', () => {
    cy.request('/api/document/auxiliary%2Fteam%2Fwolfgang.md').then(({ status, headers, body }) => {
      expect(status).to.eq(200)
      expect(headers['content-type']).to.eq('text/markdown')
      expect(body).to.include('Wolfgang Meier')
    })
  })
})

describe('/api/document/{id}/html', () => {
  it('retrieves as html', () => {
    cy.request({ method: 'GET', url: '/api/document/demo%2FCIDTC-3823-cortez.xml/html', qs: { base: 'http://foo.com' } })
      .then(({ status, body }) => {
        expect(status).to.eq(200)
        expect(body).to.include('<title')
        expect(body).to.include('base href="http://foo.com"')
      })
  })

  it('retrieves part identified by xml:id as html', () => {
    cy.request({ method: 'GET', url: '/api/document/doc%2Finstallation.xml/html', qs: { id: 'unix-installation' } })
      .then(({ status, body }) => {
        expect(status).to.eq(200)
        expect(body).to.match(/Unix installation/)
      })
  })

  it('tries to retrieve non-existing document', () => {
    cy.request({
      method: 'GET',
      url: '/api/document/foo%2Fbaz.xml/html',
      failOnStatusCode: false
    })
      .its('status').should('eq', 404)
  })
})

describe('/api/document/{id}/print', () => {
  // TODO(DP): see #185
  it.skip('retrieves as HTML optimized for print', () => {
    cy.request({
      method: 'GET',
      url: '/api/document/demo%2Fosinski.xml/print',
      qs: {
        odd: 'osinski.odd',
        base: '%2Fexist%2Fapps%2Ftei-publisher%2Ftest',
        style: ['resources%2Ffonts%2Ffont.css', 'resources%2Fcss%2Fprint.css']
      }
    }).then(({ status, body }) => {
      expect(status).to.eq(200)
      // Check for basic HTML structure instead of specific classes
      expect(body).to.include('<html')
      // expect(body).to.include('<section')
      // allow additional classes before/after doc-title
      expect(/class="[^"]*\bdoc-title\b[^"]*"/.test(body)).to.be.true
      expect(body).to.include('class="register"')
    })
  })
})

describe.skip('/api/document/{id}/tex', () => {
  // Some setups require authentication to access LaTeX transformation
  // TODO(DP): see #186
  it('retrieves as LaTeX', () => {
    cy.api({
      method: 'GET',
      url: '/api/document/test%2Flet695.xml/tex',
      qs: { source: 'true' },
      headers: { Accept: 'application/x-latex' }
    }).should((response) => {
      expect(response.status).to.eq(200)
      expect(response.headers['content-type']).to.eq('application/x-latex')
    })
  })
})
