// StandardJS, should-style assertions
// API tests for Collection browsing functionality
// Generated by jinks - DO NOT EDIT manually

describe('TEI-Publisher Collection API', () => {
  // Helper to get origin from Cypress baseUrl
  const getOrigin = () => {
    const baseUrl = Cypress.config('baseUrl')
    if (!baseUrl) {
      throw new Error('baseUrl must be configured in Cypress config')
    }
    return new URL(baseUrl).origin
  }

  beforeEach(() => {
    cy.login()
  })

  describe('List Collections', () => {
    it('retrieves list of available collections', () => {
      cy.request({
        method: 'GET',
        url: '/api/collection',
        qs: { format: 'json' },
        headers: { Origin: getOrigin() }
      }).then((response) => {
        expect(response.status).to.eq(200)
        expect(response.body).to.be.an('object')
        expect(Object.keys(response.body).length).to.be.greaterThan(0)
      })
    })

    it('returns collection metadata', () => {
      cy.request({
        method: 'GET',
        url: '/api/collection',
        qs: { format: 'json' },
        headers: { Origin: getOrigin() }
      }).then((response) => {
        expect(response.status).to.eq(200)
        expect(response.body).to.be.an('object')
      })
    })
  })

  describe('Browse Collection', () => {
    it('retrieves documents from a collection', () => {
      cy.request({
        method: 'GET',
        url: '/api/collection',
        qs: { format: 'json' },
        headers: { Origin: getOrigin() }
      }).then((collectionsResponse) => {
        expect(collectionsResponse.body).to.be.an('object')
        // If response has an all property with collections, use the first one
        if (collectionsResponse.body.all && collectionsResponse.body.all.length > 0 && collectionsResponse.body.all[0].name) {
          const firstCollection = collectionsResponse.body.all[0].name
          
          cy.request({
            method: 'GET',
            url: `/api/collection/${encodeURIComponent(firstCollection)}`,
            headers: { Origin: getOrigin() }
          }).then((response) => {
            expect(response.status).to.eq(200)
            expect(response.headers['content-type']).to.include('text/html')
          })
        }
      })
    })
  })

  describe('Collection Filtering', () => {
    it('applies filters to collection results', () => {
      cy.request({
        method: 'GET',
        url: '/api/collection',
        qs: { format: 'json' },
        headers: { Origin: getOrigin() }
      }).then((collectionsResponse) => {
        expect(collectionsResponse.body).to.be.an('object')
        // If response has an all property with collections, use the first one
        if (collectionsResponse.body.all && collectionsResponse.body.all.length > 0 && collectionsResponse.body.all[0].name) {
          const firstCollection = collectionsResponse.body.all[0].name
          
          cy.request({
            method: 'GET',
            url: `/api/collection/${encodeURIComponent(firstCollection)}`,
            qs: { filter: 'test' },
            headers: { Origin: getOrigin() }
          }).then((response) => {
            expect(response.status).to.eq(200)
          })
        }
      })
    })
  })
})

