// StandardJS, should-style assertions
// API tests for document-related endpoints
// Generated by jinks - DO NOT EDIT manually

// New documents are saved in the context.defaults.data-default collection.
import context from '../../../../context.json'
const dataDefault = context.defaults['data-default']

describe('Document API Tests', () => {
  // Helper to get origin from Cypress baseUrl
  const getOrigin = () => {
    const baseUrl = Cypress.config('baseUrl')
    if (!baseUrl) {
      throw new Error('baseUrl must be configured in Cypress config')
    }
    return new URL(baseUrl).origin
  }

  beforeEach(() => {
    cy.login()
  })

  describe('Saving documents', () => {
    it('saves in the root of the data collection', () => {
      cy.request({
        method: 'PUT',
        url: '/api/document/demo/doc.xml',
        headers: {
          'content-type': 'application/xml',
          Origin: getOrigin()
        },
        body: '<xml />'
      }).then((response) => {
        expect(response.status).to.eq(200)
        expect(response.body).to.deep.eq({
          path: `demo/doc.xml`,
          status: 'ok'
        })
      })
    })

    it('saves in a subcollection of the data collection', () => {
      cy.request({
        method: 'PUT',
        url: `/api/document/${encodeURIComponent('collection/deep/down/doc.xml')}`,
        headers: {
          'content-type': 'application/xml',
          Origin: getOrigin()
        },
        body: '<xml />'
      }).then((response) => {
        expect(response.status).to.eq(200)
        expect(response.body).to.deep.eq({
          path: `collection/deep/down/doc.xml`,
          status: 'ok'
        })
      })
    })
  })
})
