/*
 * Decompiled with CFR 0.152.
 */
package org.exist.console.xquery;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.console.xquery.ConsoleModule;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.util.serializer.json.JSONWriter;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class Log
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("log", "http://exist-db.org/xquery/console", "console"), "Logs a message to the logger using the template given in the first parameter and the 'default' channel.", new SequenceType[]{new FunctionParameterSequenceType("items", 11, 7, "Values to be printed. Will be concatenated into a single string.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "Empty")), new FunctionSignature(new QName("log", "http://exist-db.org/xquery/console", "console"), "Logs a message to the logger using the template given in the first parameter.", new SequenceType[]{new FunctionParameterSequenceType("channel", 22, 2, "The channel to print to."), new FunctionParameterSequenceType("items", 11, 7, "Values to be printed. Will be concatenated into a single string.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "Empty")), new FunctionSignature(new QName("send", "http://exist-db.org/xquery/console", "console"), "Send a json message to the console", new SequenceType[]{new FunctionParameterSequenceType("channel", 22, 2, "The channel to print to."), new FunctionParameterSequenceType("items", 11, 3, "Value to be sent. Will be transformed into JSON.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "Empty")), new FunctionSignature(new QName("dump", "http://exist-db.org/xquery/console", "console"), "Dump the local variable stack to the console, including all variables which are visible at the point the statement appears in the code. Only the variables matching one of the names given in parameter $vars are dumped. All others are ignored. Use with care: might produce lots of output.", new SequenceType[]{new FunctionParameterSequenceType("channel", 22, 2, "The channel to print to."), new FunctionParameterSequenceType("vars", 22, 6, "The names of the variables to dump.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "Empty")), new FunctionSignature(new QName("dump", "http://exist-db.org/xquery/console", "console"), "Dump the local variable stack to the console, including all variables which are visible at the point the statement appears in the code. Use with care: might produce lots of output.", new SequenceType[]{new FunctionParameterSequenceType("channel", 22, 2, "The channel to print to.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "Empty")), new FunctionSignature(new QName("dump", "http://exist-db.org/xquery/console", "console"), "Dump the local variable stack to the console, including all variables which are visible at the point the statement appears in the code. Use with care: might produce lots of output.", null, (SequenceType)new FunctionReturnSequenceType(10, 1, "Empty"))};
    private static final Properties SERIALIZATION_PROPERTIES = new Properties();
    private static final Properties JSON_SERIALIZATION_PROPERTIES;
    private Expression parent = null;

    public Log(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        this.parent = contextInfo.getParent();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        block13: {
            Properties outputProperties = new Properties(SERIALIZATION_PROPERTIES);
            if (this.isCalledAs("dump")) {
                String channel = this.getArgumentCount() == 0 ? "default" : args[0].getStringValue();
                HashSet<String> varsToPrint = null;
                if (this.getArgumentCount() == 2) {
                    varsToPrint = new HashSet<String>();
                    SequenceIterator i = args[1].iterate();
                    while (i.hasNext()) {
                        varsToPrint.add(i.nextItem().getStringValue());
                    }
                }
                StringWriter writer = new StringWriter();
                JSONWriter jsonWriter = new JSONWriter((Writer)writer);
                try {
                    jsonWriter.startDocument();
                    jsonWriter.startElement("", "result", "result");
                    Map vars = this.context.getLocalVariables();
                    for (Map.Entry var : vars.entrySet()) {
                        String name = ((QName)var.getKey()).toString();
                        if (varsToPrint != null && !varsToPrint.contains(name)) continue;
                        jsonWriter.startElement("", name, name);
                        StringBuilder value = new StringBuilder();
                        this.printItems(value, outputProperties, false, ((Variable)var.getValue()).getValue());
                        jsonWriter.characters((CharSequence)value);
                        jsonWriter.endElement("", name, name);
                    }
                    jsonWriter.endElement("", "result", "result");
                    jsonWriter.endDocument();
                    String msg = writer.toString();
                    if (this.parent == null) {
                        ConsoleModule.log(channel, true, msg);
                        break block13;
                    }
                    ConsoleModule.log(channel, this.parent.getSource().getKey().toString(), this.parent.getLine(), this.parent.getColumn(), true, msg);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            } else {
                String channel = this.getArgumentCount() == 1 ? "default" : args[0].getStringValue();
                Sequence params = this.getArgumentCount() == 1 ? args[0] : args[1];
                StringBuilder out = new StringBuilder();
                boolean jsonFormat = this.isCalledAs("send");
                if (jsonFormat) {
                    outputProperties.setProperty("method", "json");
                }
                this.printItems(out, outputProperties, jsonFormat, params);
                String msg = out.toString();
                if (this.isCalledAs("send")) {
                    ConsoleModule.send(channel, msg);
                } else if (this.parent == null) {
                    ConsoleModule.log(channel, msg);
                } else {
                    ConsoleModule.log(channel, this.parent.getSource().getKey().toString(), this.parent.getLine(), this.parent.getColumn(), msg);
                }
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private void printItems(StringBuilder out, Properties outputProperties, boolean jsonFormat, Sequence sequence) throws XPathException {
        SequenceIterator i = sequence.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (Type.subTypeOf((int)item.getType(), (int)-1)) {
                Serializer serializer = this.context.getBroker().getSerializer();
                serializer.reset();
                try {
                    serializer.setProperties(outputProperties);
                    out.append(serializer.serialize((NodeValue)item));
                }
                catch (SAXException e) {
                    out.append(e.getMessage());
                }
                continue;
            }
            if (item.getType() == 102 || item.getType() == 103) {
                StringWriter writer = new StringWriter();
                XQuerySerializer xqSerializer = new XQuerySerializer(this.context.getBroker(), JSON_SERIALIZATION_PROPERTIES, (Writer)writer);
                try {
                    xqSerializer.serialize(item.toSequence());
                    out.append(writer.toString());
                    continue;
                }
                catch (SAXException e) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
            }
            if (jsonFormat) {
                out.append('\"').append(item.getStringValue()).append('\"');
                continue;
            }
            out.append(item.getStringValue());
        }
    }

    static {
        SERIALIZATION_PROPERTIES.setProperty("indent", "yes");
        SERIALIZATION_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        JSON_SERIALIZATION_PROPERTIES = new Properties();
        JSON_SERIALIZATION_PROPERTIES.setProperty("indent", "yes");
        JSON_SERIALIZATION_PROPERTIES.setProperty("method", "json");
    }
}

