/*
 * Decompiled with CFR 0.152.
 */
package org.exist.remoteconsole;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.exist.console.xquery.ConsoleModule;
import org.exist.remoteconsole.RemoteConsoleAdapter;
import org.exist.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/rconsole")
public class RemoteConsoleEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteConsoleEndpoint.class);
    private final Map<Session, String> sessions = new ConcurrentHashMap<Session, String>();

    public RemoteConsoleEndpoint() {
        ConsoleModule.setAdapter(new RemoteConsoleAdapter(this::sendAll, this::sendAll));
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(runnable -> ThreadUtils.newGlobalThread((String)"rconsole", (Runnable)runnable));
        service.scheduleAtFixedRate(this::pingAll, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    @OnOpen
    public void openSession(Session session) {
        session.setMaxIdleTimeout(10000L);
        this.sessions.put(session, null);
    }

    @OnClose
    public void closeSession(Session session, CloseReason closeReason) {
        this.sessions.remove(session);
    }

    @OnMessage
    public void recv(String message, Session session) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(message);
            JsonNode channelNode = root.get("channel");
            if (channelNode != null) {
                String channel = channelNode.textValue();
                this.sessions.put(session, channel);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    void pingAll() {
        this.sendAll(null, "ping");
    }

    void sendAll(@Nullable String toChannel, Map data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writeValueAsString((Object)data);
            this.sendAll(toChannel, json);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    void sendAll(@Nullable String toChannel, String message) {
        Iterator<Map.Entry<Session, String>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<Session, String> entry = iterator.next();
                Session session = entry.getKey();
                String channel = entry.getValue();
                if (toChannel != null && (channel == null || !toChannel.equals(channel))) continue;
                session.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                LOG.error("Error sending message via websocket: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

